;; Interlace text mode for the NTSC VIC-20 by Marko Mkel
;;
;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2 of the License, or
;; (at your option) any later version.

	processor 6502
	seg code

CYCLES_PER_LINE = 65		; number of processor cycles per raster line
VIA_RELOAD_TIME = 2		; number of cycles needed to reload the VIA
LINES_i = 525			; lines per interlaced frame
LINES_e = 262			; lines per even frame
LINES_o = 263			; lines per odd frame
TIMER_o = LINES_o * CYCLES_PER_LINE - VIA_RELOAD_TIME
TIMER_e = LINES_e * CYCLES_PER_LINE - VIA_RELOAD_TIME

	org $1001
	dc.w .nextline
	dc.w 1998		; line number
	dc.b $9e		; SYS token
	;; SYS digits
	if start / 10000
		dc.b $30 + start / 10000
	endif
	if start / 1000
		dc.b $30 + start % 10000 / 1000
	endif
	if start / 100
		dc.b $30 + start % 1000 / 100
	endif
	if start / 10
		dc.b $30 + start % 100 / 10
	endif
	dc.b $30 + start % 10
	dc.b 0
.nextline:
	dc.w 0			; end of BASIC program

start:	sei
	lda #$40		; enable Timer A free run on VIA 1
	sta $912b
	lda #<TIMER_o
	ldx #>TIMER_o
	sta $9126		; load the timer low byte latch

	lda $9000
	ora #$80
	sta $9000		; enable interlace mode

	lda #LINES_i / 4	; wait for last line
.last:	bit $9003
	beq .last
	cmp $9004
	bne .last

	stx $9125		; start Timer A

	lda #<irq_o
	sta $314
	lda #>irq_o
	sta $315
	lda #$c0
	sta $912e		; enable Timer A underflow interrupts
	cli
	rts

irq_o:	lda #<TIMER_e
	sta $9126
	lda #<irq_e
	sta $314
	lda $9005
	and #$f0
	ora #$0d
	sta $9005		; change character set
	jmp $eabf

	if >. - >irq_o
		echo "fatal: page boundary crossed"
		err
	endif

irq_e:	lda #<TIMER_o
	sta $9126
	lda #<irq_o
	sta $314
	lda $9005
	and #$f0
	ora #$0e
	sta $9005		; change character set
	jmp $eabf

	org $1400
	incbin "font.bin"
